/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.workflowstab;

import filenet.sim.api.VWScenarioArrivalDefinition;
import filenet.sim.api.VWScenarioWorkflowDefinition;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

class VWSIMArrivalsDataFieldsTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 3;
    public static final int COL_NAME = 0;
    public static final int COL_TYPE = 1;
    public static final int COL_VALUE = 2;
    private VWSIMPropertyData m_propertyData = null;
    private Vector m_rowData = null;
    private VWScenarioWorkflowDefinition m_scenarioWfDef = null;
    private VWScenarioArrivalDefinition m_arrivalDef = null;
    private String[][] m_fieldAssignments = null;
    private boolean m_bReplace = true;

    public VWSIMArrivalsDataFieldsTableModel(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.m_rowData = new Vector();
    }

    public void setArrivalDefinition(VWSIMPropertyData propertyData, VWScenarioWorkflowDefinition scenarioWfDef, VWScenarioArrivalDefinition arrivalDef) {
        this.m_propertyData = propertyData;
        this.m_arrivalDef = arrivalDef;
        this.m_scenarioWfDef = scenarioWfDef;
        this.reinitialize(arrivalDef, scenarioWfDef);
    }

    public void reinitialize(VWScenarioArrivalDefinition arrivalDef, VWScenarioWorkflowDefinition scenarioWfDef) {
        VWWorkflowDefinition wfDef = null;
        this.m_rowData.removeAllElements();
        this.m_fieldAssignments = null;
        this.m_scenarioWfDef = scenarioWfDef;
        if (scenarioWfDef != null) {
            wfDef = scenarioWfDef.getWorkflowDefinition();
        }
        try {
            if (arrivalDef != null) {
                this.m_fieldAssignments = arrivalDef.getFieldAssignments();
                if (this.m_fieldAssignments != null) {
                    for (int i = 0; i < this.m_fieldAssignments.length; ++i) {
                        String name = this.m_fieldAssignments[i][0];
                        VWFieldDefinition field = wfDef.getField(name);
                        int type = field.getFieldType();
                        String value = this.m_fieldAssignments[i][1];
                        DataFieldsTableObject fieldObj = new DataFieldsTableObject(name, type, value);
                        this.m_rowData.addElement(fieldObj);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.fireTableDataChanged();
    }

    public Object getItemAt(int nRowIndex) {
        int nRowDataCount = this.m_rowData.size();
        if (nRowDataCount > 0 && nRowIndex >= 0 && nRowIndex < nRowDataCount) {
            return (DataFieldsTableObject)this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }

    public Class getColumnClass(int nColumnIndex) {
        return String.class;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int column) {
        String resultString = null;
        switch (column) {
            case 0: {
                resultString = VWSIMResource.s_name;
                break;
            }
            case 1: {
                resultString = VWSIMResource.s_type;
                break;
            }
            case 2: {
                resultString = VWSIMResource.s_expression;
            }
        }
        return resultString;
    }

    public int getRowCount() {
        return this.m_rowData.size();
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            DataFieldsTableObject rowData = (DataFieldsTableObject)this.getItemAt(nRowIndex);
            if (rowData == null) {
                return null;
            }
            switch (nColumnIndex) {
                case 1: {
                    return new Integer(rowData.getFieldType());
                }
                case 0: {
                    return rowData.getFieldName();
                }
                case 2: {
                    return rowData.getFieldValue();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 2: {
                this.onUpdateValue(aValue, nRowIndex);
            }
        }
    }

    private void onUpdateValue(Object aValue, int nRowIndex) {
        try {
            String value = (String)aValue;
            if (value != null && value.length() > 0) {
                DataFieldsTableObject dataObj = (DataFieldsTableObject)this.getItemAt(nRowIndex);
                if (dataObj != null) {
                    dataObj.setFieldValue(value);
                    this.m_fieldAssignments[nRowIndex][1] = value;
                    this.m_arrivalDef.setFieldAssignments(this.m_fieldAssignments);
                }
                this.m_propertyData.setDirty();
                this.fireTableCellUpdated(nRowIndex, 2);
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_propertyData.getParentFrame(), ex.getLocalizedMessage(), 1);
        }
    }

    private class DataFieldsTableObject {
        String m_fieldName = null;
        int m_fieldType = -1;
        String m_fieldValue = null;

        DataFieldsTableObject(String fieldName, int fieldType, String fieldValue) {
            this.m_fieldName = fieldName;
            this.m_fieldType = fieldType;
            this.m_fieldValue = fieldValue;
        }

        String getFieldName() {
            return this.m_fieldName;
        }

        int getFieldType() {
            return this.m_fieldType;
        }

        String getFieldValue() {
            return this.m_fieldValue;
        }

        void setFieldValue(String value) {
            this.m_fieldValue = value;
        }
    }
}

